unit MainAssembler;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,
  stSecUtils,
  stCustomProtoComp,
  stSecComp,
  StreamSec.DSI.ArithComp, StreamSec.Mobile.X509Comp,
  StreamSec.Mobile.TlsInternalServer;

type
  TForm60 = class(TForm)
    stRSAKey: TstRSAKey;
    btnLoadPrivKey: TButton;
    dlgOpenPrivateKey: TOpenDialog;
    btnAddCertificate: TButton;
    dlgOpenCertificate: TOpenDialog;
    memCertList: TMemo;
    btnSavePFX: TButton;
    dlgSavePFX: TSaveDialog;
    lblPrivateKeyLoaded: TLabel;
    procedure stRSAKeyPassword(Sender: TObject; aPassword: iSecretKey);
    procedure btnAddCertificateClick(Sender: TObject);
    procedure btnSavePFXClick(Sender: TObject);
    procedure btnLoadPrivKeyClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form60: TForm60;

implementation

uses
  stGC,
  StreamSec.DSI.IFC,
  StreamSec.DSI.Pkcs1,
  StreamSec.DSI.Pkcs1Format,
  stDES,
  stMD5,
  StreamSec.DSI.Pkcs8Format,
  stMD2,
  stSHA1,
  stPkcs5,
  stArc2,
  stAes,
  StreamSec.DSI.CAPIFormat,
  stArc4,
  StreamSec.DSI.TextFormat,
  StreamSec.DSI.NETFormat,
  stDrbgAesCtr,
  stDERUtils,
  stDERCoder,
  stPEMCOder,
  StreamSec.DSI.Pkcs12,
  StreamSec.DSI.PkixCert,
  StreamSec.DSI.PKTypes;

{$R *.dfm}

procedure TForm60.btnAddCertificateClick(Sender: TObject);
begin
  if dlgOpenCertificate.Execute then begin
    if memCertList.Tag = 1 then begin
      memCertList.Clear;
      memCertList.Tag := 0;
    end;
    memCertList.Lines.Add(dlgOpenCertificate.FileName);
    btnSavePFX.Enabled := True;
  end;
end;

procedure TForm60.btnLoadPrivKeyClick(Sender: TObject);
begin
  if dlgOpenPrivateKey.Execute then begin
    stRSAKey.PrivateKeyFileName := dlgOpenPrivateKey.FileName;
    stRSAKey.Enabled := True;
    if stRSAKey.Enabled then
      lblPrivateKeyLoaded.Caption := 'Private Key Loaded'
    else
      lblPrivateKeyLoaded.Caption := 'No Private Key'
  end;
end;

procedure TForm60.btnSavePFXClick(Sender: TObject);
var
  lPFX: iPFX;
  lPW: iSecretKey;
  lFriendlyName: UnicodeString;
  lKeyAndCertStore: iKeyAndCertStoreEx;
  lEndEntityCert,
  lCert: iCertificate;
  lKey: iIFPrivateKey;
  lLocalKeyID: OctetString;
  lPassword: string;
  lFilename: string;
  I: Integer;
begin
  if dlgSavePFX.Execute then begin
    InputQuery('New PFX File','Enter password: ',lPassword);
    lKey := stRSAKey as iIFPrivateKey;
    if Assigned(lKey) then begin
      lPFX := tPFX.Create(gcamFirstAssignment);
      Supports(lPFX,iKeyAndCertStoreEx,lKeyAndCertStore);
      lPW := tSecretKey.CreateBMPStr(PWideChar(lPassword),Length(lPassword));
      // Private key
      lLocalKeyId := HexToOS('01000000');
      lEndEntityCert := tCertificate.GetActualClass.Create(gcamFirstAssignment) as iCertificate;
      lFilename := memCertList.Lines[memCertList.Lines.Count-1];
      if SameText(ExtractFileExt(lFilename),'.pem') then
        lEndEntityCert.GetStruct.LoadFromFile(lFilename,fmtPEM)
      else
        lEndEntityCert.GetStruct.LoadFromFile(lFilename,fmtDER);
      lEndEntityCert.GetStruct.ExpandFull;
      lFriendlyName := OSToHex(lEndEntityCert.PublicKeyIdentifier,True);
      lKeyAndCertStore.StorePrivateKeyEx(lPW,
                                         lKey,
                                         lEndEntityCert.subjectPublicKeyInfo.algorithm.algorithm,
                                         lFriendlyName,
                                         'Microsoft RSA SChannel Cryptographic Provider',
                                         lLocalKeyID,
                                         lEndEntityCert.GetKeyUsage,
                                         True);
      // Certificate chain
      lFriendlyName := 'StrSecIV CertMgr ' + DateTimeToStr(Now);
      lKeyAndCertStore.StoreCertificate(lPW,lEndEntityCert,lFriendlyName,lLocalKeyID);
      for I := memCertList.Lines.Count - 2 downto 0 do begin
        lCert := tCertificate.GetActualClass.Create(gcamFirstAssignment) as iCertificate;
        lFilename := memCertList.Lines[I];
        if SameText(ExtractFileExt(lFilename),'.pem') then
          lCert.GetStruct.LoadFromFile(lFilename,fmtPEM)
        else
          lCert.GetStruct.LoadFromFile(lFilename,fmtDER);
        lCert.GetStruct.ExpandFull;
        lKeyAndCertStore.StoreCertificate(lPW,lCert,'',cEmptyOS);
      end;
      // Save
      lPFX.ImposeAuthSafeContent(lPW);
      lPFX.version := tPFXVersion.V3;
      lPFX.GetStruct.SaveToFile(dlgSavePFX.FileName,fmtDER);
    end;
  end;
end;

procedure TForm60.stRSAKeyPassword(Sender: TObject; aPassword: iSecretKey);
var
  lPW: string;
begin
  InputQuery(stRSAKey.PrivateKeyFileName,'Enter password: ',lPW);
  aPassword.SetKeyStr(UnicodeToUtf8(lPW));
end;

end.
